/*
 *  Arnold emulator (c) Copyright, Kevin Thacker 1995-2015
 *
 *  This file is part of the Arnold emulator source code distribution.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __TIMER_HEADER_INCLUDED__
#define __TIMER_HEADER_INCLUDED__

#include "../cpcglob.h"

#define MAX_TIMING_HISTORY 256

typedef enum
{
	TIMER_START,
	TIMER_END,
	TIMER_HIT
} TIMER_TYPE;

/* define a template/preset for an i/o TIMER */
typedef struct _TIMER
{
	int nTimings;
	int nTimingPosition;
	int TimingHistory[MAX_TIMING_HISTORY];

	int Address;
	int LastHitTime;

	BOOL RequireRefreshInGUI;
	BOOL bEnabled;
	BOOL bFirstHit;
	
	TIMER_TYPE Type;
	struct _TIMER *pNext;
} TIMER;


typedef struct
{
	int nMin;
	int nMax;
	int nAvg;
} TIMER_STATS;


BOOL Timer_GetStats(TIMER *pTimer, TIMER_STATS *pStats, BOOL bFPS);

BOOL Timers_FullRefreshInGUI(void);
void Timers_SetFullRefreshInGUI(BOOL bState);
void Timers_SetEnabled(TIMER *pTimer, BOOL bEnable);

TIMER *Timers_AddTimer(TIMER_TYPE Type,int nAddress);

void    Timers_RemoveTimer(TIMER *pTimer);
TIMER *Timers_GetFirst(void);
TIMER *Timers_GetNext(TIMER *pTimer);


BOOL Timer_RequireRefreshInGUI(TIMER *pBreakpoint);
void Timer_SetRequireRefreshInGUI(TIMER *pBreakpoint, BOOL bState);
void Timers_Update(int nAddress);
void Timers_Free(void);
void Timer_Reset(TIMER *pTimer);



#endif

